﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Imports System.Drawing.Drawing2D

Public Class MainForm

    ''' <summary>
    ''' 定义所有类变量。
    ''' 由于 Brush 为 MustInherit（抽象）类，此画笔
    ''' 实际上将包含其他 5 类画笔的实例。
    ''' </summary>
    ''' <remarks></remarks>
    Dim demoBrush As Brush              ' 演示画笔    
    Dim color1 As Color = Color.Blue    ' 主要作为前景色
    Dim color2 As Color = Color.White   ' 主要作为背景色
    Dim demoPen As Pen                  ' 在绘制线条时使用的钢笔
    Dim brushSize As Rectangle          ' 在平铺画笔时使用的矩形
    Dim formGraphics As Graphics        ' 用于绘制画笔的 Graphics 对象

    ''' <summary>
    ''' 此子例程用于设置 color1 值。
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub btnSetColor1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSetColor1.Click
        Dim cdlg As New ColorDialog()

        If cdlg.ShowDialog() = Windows.Forms.DialogResult.OK Then
            color1 = cdlg.Color
            txtColor1.Text = cdlg.Color.ToString()
            txtColor1.BackColor = cdlg.Color
        End If
    End Sub

    ''' <summary>
    ''' 此子例程用于设置 color2 值。
    ''' </summary>
    Private Sub btnSetColor2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSetColor2.Click
        Dim cdlg As New ColorDialog()

        If cdlg.ShowDialog() = Windows.Forms.DialogResult.OK Then
            color2 = cdlg.Color
            txtColor2.Text = cdlg.Color.ToString()
            txtColor2.BackColor = cdlg.Color
        End If

    End Sub


    ''' <summary>
    ''' 此子例程通过定义新的矩形，更改用于在 
    ''' PictureBox 中绘制的画笔的大小。这些矩形可以是
    ''' 已定义的。
    ''' </summary>
    Private Sub cboBrushSize_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cboBrushSize.SelectedIndexChanged
        Select Case cboBrushSize.Text
            Case "Large"
                ' “Large”占据 picDemoArea 的全部
                brushSize = New Rectangle(0, 0, _
                    picDemoArea.Width, picDemoArea.Height)
            Case "Medium"
                ' “Medium”将 picDemoArea 划分为 4 个部分
                brushSize = New Rectangle(0, 0, _
                    picDemoArea.Width \ 2, picDemoArea.Height \ 2)
            Case "Small"
                ' “Small”将 picDemoArea 划分为 16 个部分
                brushSize = New Rectangle(0, 0, _
                    picDemoArea.Width \ 4, picDemoArea.Height \ 4)
        End Select

        ' 调用 RedrawPicture
        RedrawPicture(cboBrushSize, New EventArgs())
    End Sub


    ''' <summary>
    ''' 这样将在加载窗体时使用默认设置绘制图形。
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub Form1_Activated(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Activated, MyBase.Activated
        brushSize = New Rectangle(0, 0, _
            picDemoArea.Width, picDemoArea.Height)
        ' 调用 RedrawPicture
        RedrawPicture(cboBrushSize, New EventArgs())
    End Sub


    ''' <summary>
    ''' 此子例程确保正确设置用户界面 
    ''' 并将一些变量设置为它们的初始值。
    ''' </summary>
    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        ' 将画笔大小设置为默认等于整个图片框区域
        brushSize = New Rectangle(0, 0, picDemoArea.Width, picDemoArea.Height)

        ' 使用各个 WrapMode 枚举值填充 cboWrapMode 组合框。 
        ' 共享方法 Enum.GetValues 返回所有换行模式的数组。
        For Each mode As WrapMode In System.Enum.GetValues(GetType(WrapMode))
            cboWrapMode.Items.Add(mode)
        Next

        ' 填充阴影样式组合框  
        For Each style As HatchStyle In System.Enum.GetValues(GetType(HatchStyle))
            cboHatchStyle.Items.Add(style)
        Next

        ' 填充可用的 GradientStyle
        For Each gradient As LinearGradientMode In System.Enum.GetValues(GetType(LinearGradientMode))
            cboGradientMode.Items.Add(gradient)
        Next
    End Sub


    ''' <summary>
    ''' 此子例程包括大量演示。 它创建
    ''' 5 种画笔类型中的一种，并将相应的用户定义的参数分配给
    ''' 该画笔。然后将该画笔分配给 demoBrush，后者用于 
    ''' 绘制三种不同的形状之一。还有用于确保 
    ''' UI 仅显示适合正在使用的画笔类型的选项
    ''' 的代码。
    ''' 请注意，此错误处理程序几乎可处理 UI 激发的
    ''' 所有事件。
    ''' </summary>
    Private Sub RedrawPicture(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cboBrushType.SelectedIndexChanged, cboDrawing.SelectedIndexChanged, txtColor1.TextChanged, cboWrapMode.SelectedIndexChanged, cboHatchStyle.SelectedIndexChanged, txtColor2.TextChanged, cboGradientMode.SelectedIndexChanged, nudRotation.ValueChanged, nudGradientBlend.ValueChanged

        ' 重置 PictureBox
        picDemoArea.CreateGraphics().Clear(Color.White)
        picDemoArea.Refresh()

        ' 重置状态栏
        Me.sbrDrawingStatus.Text = ""

        ' 使用用户选择的属性构造画笔。将根据
        ' 用户选择创建五种不同画笔之一。
        ' 创建特定类型的画笔然后再将其分配给
        ' demoBrush 的原因在于，在处理特定的画笔对象时 
        ' 可以使用 Intellisense。
        Select Case cboBrushType.Text

            Case "Solid" ' 使用 SolidBrush

                ' 更新 UI：停用并重新激活所有适用于此画笔的 
                ' 控件
                Me.cboBrushSize.Enabled = False
                Me.cboHatchStyle.Enabled = False
                Me.cboWrapMode.Enabled = False
                Me.txtColor2.Enabled = False
                Me.btnSetColor2.Enabled = False
                Me.nudGradientBlend.Enabled = False
                Me.nudRotation.Enabled = False
                Me.cboGradientMode.Enabled = False

                ' 基于所选颜色创建纯色画笔
                Dim mySolidBrush As New SolidBrush(color1)

                ' 如果知道在设计时需要的颜色，
                ' 获得纯色画笔的另一个方法是使用 Brushes 类
                ' 例如，下面这一行将生成一个 AliceBlue 画笔
                ' demoBrush = Brushes.AliceBlue

                ' 将 demoBrush 设置为与新创建的画笔相等价
                demoBrush = mySolidBrush

            Case "Hatch" ' 使用 HatchBrush

                ' 更新 UI：停用并重新激活所有适用于此画笔的 
                ' 控件
                Me.cboBrushSize.Enabled = False
                Me.cboHatchStyle.Enabled = True
                Me.cboWrapMode.Enabled = False
                Me.txtColor2.Enabled = True
                Me.btnSetColor2.Enabled = True
                Me.nudGradientBlend.Enabled = False
                Me.nudRotation.Enabled = False
                Me.cboGradientMode.Enabled = False

                ' 使用两种颜色作为前景色和 
                ' 背景色设置创建一个新的 HatchBrush。
                ' 由于 HatchStyle 属性是只读的，HatchStyle
                ' 必须在创建 HatchBrush 时设置
                Dim myHatchBrush As New HatchBrush( _
                    CType(cboHatchStyle.SelectedItem, HatchStyle), _
                    color1, color2)

                ' 将 demoBrush 设置为与新创建的画笔相等价
                demoBrush = myHatchBrush

            Case "Texture" ' 使用 TextureBrush

                ' 更新 UI：停用并重新激活所有适用于此画笔的 
                ' 控件
                Me.cboBrushSize.Enabled = True
                Me.cboHatchStyle.Enabled = False
                Me.cboWrapMode.Enabled = True
                Me.txtColor2.Enabled = False
                Me.btnSetColor2.Enabled = False
                Me.nudGradientBlend.Enabled = False
                Me.nudRotation.Enabled = True
                Me.cboGradientMode.Enabled = False

                ' 创建一个基于位图的新 TextureBrush。此位图
                ' 还可以是已创建的图案。
                ' 此处要小心，因为定义比所提供的位图更大的矩形
                ' 将导致引发 OutOfMemory 
                ' 异常。
                Dim myTextureBrush As New TextureBrush( _
                    My.Resources.WaterLilies, brushSize)

                ' 在画笔的应用不是遍及整个图形区域时，WrapMode 确定
                ' 其平铺方式。
                myTextureBrush.WrapMode = CType(cboWrapMode.SelectedItem, WrapMode)

                ' RotateTransform 方法将画笔旋转用户所指定的
                ' 量
                myTextureBrush.RotateTransform(nudRotation.Value)

                ' 也可使用 ScaleTransform 将画笔进行变形
                ' 下面的过程对画笔进行剪切，使其宽度减半，
                ' 高度加倍。
                'myTextureBrush.ScaleTransform(0.5F, 2.0F)

                ' 将 demoBrush 设置为与新创建的画笔相等价
                demoBrush = myTextureBrush

            Case "LinearGradient" ' 使用 LinearGradientBrush

                ' 更新 UI：停用并重新激活所有适用于此画笔的 
                ' 控件
                Me.cboBrushSize.Enabled = True
                Me.cboHatchStyle.Enabled = False
                Me.cboWrapMode.Enabled = True
                Me.txtColor2.Enabled = True
                Me.btnSetColor2.Enabled = True
                Me.nudGradientBlend.Enabled = True
                Me.nudRotation.Enabled = True
                Me.cboGradientMode.Enabled = True

                ' 创建一个新的 LinearGradientBrush。该画笔基于
                ' 由一个矩形定义的大小，在此例中使用
                ' 用户定义的 brushSize。使用两种颜色定义
                ' 渐变的起始和结束颜色。（更高级 
                ' 的渐变可以使用 Blend 属性生成。）
                ' 最后在构造函数中定义 LinearGradientMode。
                ' 也可以使用角度，不过为简单起见，此处未使用。
                Dim myLinearGradientBrush As New LinearGradientBrush( _
                    brushSize, color1, color2, _
                    CType(cboGradientMode.SelectedItem, LinearGradientMode))

                ' 在画笔的应用不是遍及整个图形区域时，WrapMode 确定
                ' 其平铺方式。
                ' LinearGradientBrush 不能使用 WrapMode 的 Clamp 值
                If CType(cboWrapMode.SelectedItem, WrapMode) <> WrapMode.Clamp Then
                    myLinearGradientBrush.WrapMode = _
                        CType(cboWrapMode.SelectedItem, WrapMode)
                Else
                    Me.sbrDrawingStatus.Text += _
                        "A Linear Gradient Brush cannot use the Clamp WrapMode."
                End If

                ' RotateTransform 方法将画笔旋转用户所指定的
                ' 量
                myLinearGradientBrush.RotateTransform(nudRotation.Value)

                ' 也可使用 ScaleTransform 将画笔进行变形
                ' 下面的过程对画笔进行剪切，使其宽度减半，
                ' 高度加倍。
                'myLinearGradientBrush.ScaleTransform(0.5F, 2.0F)

                ' 设置混合的聚焦点。允许
                ' 0 和 1 之间的任何单精度数。默认值为 1。
                myLinearGradientBrush.SetBlendTriangularShape( _
                    nudGradientBlend.Value)

                ' 对于更高级的用途，可以使用 SetSigmaBellShape
                ' 方法设置渐变中心的位置。
                'myLinearGradientBrush.SetSigmaBellShape(0.2)

                ' 将 demoBrush 设置为与新创建的画笔相等价
                demoBrush = myLinearGradientBrush

            Case "PathGradient" ' 使用 PathGradientBrush

                ' 更新 UI：停用并重新激活所有适用于此画笔的 
                ' 控件
                Me.cboBrushSize.Enabled = True
                Me.cboHatchStyle.Enabled = False
                Me.cboWrapMode.Enabled = True
                Me.txtColor2.Enabled = True
                Me.btnSetColor2.Enabled = True
                Me.nudGradientBlend.Enabled = True
                Me.nudRotation.Enabled = True
                Me.cboGradientMode.Enabled = False

                ' 定义用于作为此渐变将遵循的路径的
                ' 一组点。也可以定义和使用一个 GraphicsPath
                ' 对象。在此例中，我们使用一个简单的三角形。
                Dim pathPoint() As Point = {New Point(0, brushSize.Height), _
                        New Point(brushSize.Width, brushSize.Height), _
                        New Point(brushSize.Width, 0)}

                ' 基于刚才创建的路径创建一个新的 PathGradientBrush。
                ' （未在该路径边界内的任何内容都将是透明的，
                ' 不会包含色彩。）
                Dim myPathGradientBrush As New PathGradientBrush(pathPoint)

                ' 设置 PathGradient 的颜色，这与其他渐变的
                ' 设置方式不同，因为可以对每个边使用不同的
                ' 颜色。此例中仅使用了一种颜色，但是可以向
                ' 该路径的每个边分配颜色。
                ' CenterColor 是边缘的混合颜色。
                myPathGradientBrush.CenterColor = color1
                ' SurroundColors 是定义边缘
                ' 周围的颜色的颜色数组。
                myPathGradientBrush.SurroundColors = New Color() {color2}

                ' 对于高级用途，可以将 CenterPoint 属性设置为
                ' 该路径中心以外的其他位置（甚至是
                ' 围绕该路径的矩形之外的位置）。
                'myPathGradientBrush.CenterPoint = New PointF(50, 50)

                ' 在画笔的应用不是遍及整个图形区域时，WrapMode 确定
                ' 其平铺方式。
                myPathGradientBrush.WrapMode = _
                    CType(cboWrapMode.SelectedItem, WrapMode)

                ' RotateTransform 方法将画笔旋转用户所指定的
                ' 量
                myPathGradientBrush.RotateTransform(nudRotation.Value)

                ' 也可使用 ScaleTransform 将画笔进行变形
                ' 下面的过程对画笔进行剪切，使其宽度减半，
                ' 高度加倍。
                'myPathGradientBrush.ScaleTransform(0.5F, 2.0F)

                ' 设置混合
                myPathGradientBrush.SetBlendTriangularShape( _
                    nudGradientBlend.Value)

                ' 对于更高级用途，可以使用 SetSigmaBellShape
                ' 方法设置渐变中心的位置。
                'myPathGradientBrush.SetSigmaBellShape(0.2)

                ' 将 demoBrush 设置为与新创建的画笔相等价
                demoBrush = myPathGradientBrush
            Case Else
                demoBrush = New SolidBrush(color1)
        End Select

        ' 使用画笔在 picDemoArea 中绘制适当的图画
        formGraphics = picDemoArea.CreateGraphics()

        ' 基于用户输入选择图画类型
        Select Case cboDrawing.Text
            Case "Fill"
                ' “Fill”填充整个 PictureBox
                formGraphics.FillRectangle(demoBrush, 0, 0, _
                    picDemoArea.Width, picDemoArea.Height)

            Case "Ellipses"
                ' “Ellipses”绘制两个相交的椭圆
                formGraphics.FillEllipse(demoBrush, picDemoArea.Width \ 10, _
                    picDemoArea.Height \ 10, picDemoArea.Width \ 2, _
                    picDemoArea.Height \ 2)
                formGraphics.FillEllipse(demoBrush, picDemoArea.Width \ 3, _
                    picDemoArea.Height \ 3, picDemoArea.Width \ 2, _
                    picDemoArea.Height \ 2)
            Case "Lines"
                ' “Lines”绘制一系列交叉线条

                ' 首先基于画笔生成一个钢笔
                Dim demoPen As New Pen(demoBrush, 40)

                ' 现在从每个角落向其他所有角落绘制图画
                formGraphics.DrawLine( _
                    demoPen, 0, 0, picDemoArea.Width, picDemoArea.Height)
                formGraphics.DrawLine(demoPen, 0, 0, 0, picDemoArea.Height)
                formGraphics.DrawLine(demoPen, 0, 0, picDemoArea.Width, 0)
                formGraphics.DrawLine(demoPen, picDemoArea.Width, 0, _
                    picDemoArea.Width, picDemoArea.Height)
                formGraphics.DrawLine(demoPen, 0, picDemoArea.Height, _
                    picDemoArea.Width, picDemoArea.Height)
                formGraphics.DrawLine( _
                    demoPen, picDemoArea.Width, 0, 0, picDemoArea.Height)

        End Select

        ' 如果没有其他问题，则将绘制状态设置为“Success”。
        If Me.sbrDrawingStatus.Text = "" Then
            Me.sbrDrawingStatus.Text = "Success!"
        End If

    End Sub

    Private Sub ExitToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ExitToolStripMenuItem.Click
        Close()
    End Sub
End Class
